<?php
/**
 * @package     TabNav Web Accessibility
 * @subpackage  mod_tabnav_web_accessibility
 * @copyright   Copyright (C) 2025 TabNav. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;

// Fixed script URL
$scriptUrl = 'https://widget.tabnav.com/limited-widget.min.js.gz';

// Get color values based on custom color toggle
$widgetColor = $params->get('use_custom_color') === 'custom' ? $params->get('color', '') : '';
$buttonColor = $params->get('use_custom_button_color') === 'custom' ? $params->get('button_color', '') : '';

// Build configuration from module parameters
$config = [
    'language' => $params->get('language', 'us-en'),
    'buttonSize' => $params->get('button_size', 'large'),
    'widgetSize' => $params->get('widget_size', 'large'),
    'widgetLocation' => $params->get('widget_location', 'right'),
    'color' => $widgetColor,
    'buttonColor' => $buttonColor
];

// Convert to JSON
$configJson = json_encode($config);

// Add script with defer and custom data attribute
$document = Factory::getDocument();
$document->addScript($scriptUrl, [], ['defer' => true, 'tnv-data-config' => $configJson]);

// Add noscript fallback
$noscript = '<noscript>JavaScript is required for our <a href="https://tabnav.com">website accessibility</a> to work properly.</noscript>';
$document->addCustomTag($noscript);

// Load template using new namespace
require ModuleHelper::getLayoutPath('tabnav-web-accessibility', $params->get('layout', 'default'));